# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Get publishing pages currently checked-out
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to SharePoint site
$webUrl = "http://sharepoint/site"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint Site
$web = Get-SPWeb $webUrl
	
# Get the Publishing Site from the SharePoint Site
$pubWeb = [Microsoft.SharePoint.Publishing.PublishingWeb]::GetPublishingWeb($web)

# Get the Publishing Pages from the Site
$pages = $pubWeb.GetPublishingPages()

# Iterate through the collection of Pages
foreach ($page in $pages)
{
	# If the Page is checked out, output the details
	if ($page.ListItem.File.Level -eq [Microsoft.SharePoint.SPFileLevel]::Checkout)
	{
		Write-Host $page.Url
		Write-Host "By: " $page.ListItem.File.CheckedOutByUser.LoginName
		Write-Host "Since: " $page.ListItem.File.CheckedOutDate.ToString()
		Write-Host ""
	}
}

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 